package main

import (
  "testing"
  "fmt"
)

func TestCompactEncode(t *testing.T) {
  test1 := []int{1,2,3,4,5}
  if res := CompactEncode(test1); res != "\x11\x23\x45" {
    t.Error(fmt.Sprintf("even compact encode failed. Got: %q", res))
  }

  test2 := []int{0, 1, 2, 3, 4, 5}
  if res := CompactEncode(test2); res != "\x00\x01\x23\x45" {
    t.Error(fmt.Sprintf("odd compact encode failed. Got: %q", res))
  }

  test3 := []int{0, 15, 1, 12, 11, 8, /*term*/16}
  if res := CompactEncode(test3); res != "\x20\x0f\x1c\xb8" {
    t.Error(fmt.Sprintf("odd terminated compact encode failed. Got: %q", res))
  }

  test4 := []int{15, 1, 12, 11, 8, /*term*/16}
  if res := CompactEncode(test4); res != "\x3f\x1c\xb8" {
    t.Error(fmt.Sprintf("even terminated compact encode failed. Got: %q", res))
  }
}

// Helper function for comparing slices
func CompareIntSlice(a, b []int) bool {
  if len(a) != len(b) {
    return false
  }
  for i, v := range a {
    if v != b[i] {
      return false
    }
  }
  return true
}

func TestCompactHexDecode(t *testing.T) {
  exp := []int{7, 6, 6, 5, 7, 2, 6, 2, 16}
  res := CompactHexDecode("verb")

  if !CompareIntSlice(res, exp) {
    t.Error("Error compact hex decode. Expected", exp, "got", res)
  }
}
