package proof

import(
        "github.com/ipfs/go-cid"
        "github.com/filecoin-project/go-state-types/abi"
)

type SectorInfo struct {
     SealProof    abi.RegisteredSealProof // RegisteredProof used when sealing - needs to be mapped to PoSt registered proof when used to verify a PoSt
     SectorNumber abi.SectorNumber
     SealedCID    cid.Cid // CommR
}

type SealVerifyInfo struct {
     SealProof             abi.RegisteredSealProof
     SectorID              abi.SectorID
     DealIDs               []abi.DealID
     Randomness            abi.SealRandomness
     InteractiveRandomness abi.InteractiveSealRandomness
     Proof                 []byte

     // Safe because we get those from the miner actor
     SealedCID             cid.Cid `checked:"true"` // CommR
     UnsealedCID           cid.Cid `checked:"true"` // CommD
}

type AggregateSealVerifyInfo struct {
        Number                abi.SectorNumber
        Randomness            abi.SealRandomness
        InteractiveRandomness abi.InteractiveSealRandomness

        // Safe because we get those from the miner actor
        SealedCID             cid.Cid `checked:"true"` // CommR
        UnsealedCID           cid.Cid `checked:"true"` // CommD
}

type AggregateSealVerifyProofAndInfos struct {
        Miner          abi.ActorID
        SealProof      abi.RegisteredSealProof
        AggregateProof abi.RegisteredAggregationProof
        Proof          []byte
        Infos          []AggregateSealVerifyInfo
}

type PoStProof struct {
     PoStProof  abi.RegisteredPoStProof
     ProofBytes []byte
}

type WinningPoStVerifyInfo struct {
     Randomness        abi.PoStRandomness
     Proofs            []PoStProof
     ChallengedSectors []SectorInfo
     Prover            abi.ActorID // used to derive 32-byte prover ID
}

type WindowPoStVerifyInfo struct {
     Randomness        abi.PoStRandomness
     Proofs            []PoStProof
     ChallengedSectors []SectorInfo
     Prover            abi.ActorID // used to derive 32-byte prover ID
}

type AggregateWindowPostInfos struct{
    PoStType          abi.RegisteredPoStProof
    AggregateType     abi.RegisteredAggregationProof
    Miner             abi.ActorID
    AggregationProof  []byte
    ChallengedSectors []SectorInfo
    SectorCount       []uint
    Randomnesses      []abi.PoStRandomness
}