package seal

import (
	"fil_integrate/build/cid"
	spproof "fil_integrate/build/proof"
	"fil_integrate/build/state-types/abi"
	ffi "github.com/mfdzh/filecoin-ffi"
)

type Verifier struct{}

var ProofVerifier = Verifier{}

var _ SectorVerifier = Verifier{}

func NewVerifier() Verifier {
	return Verifier{}
}

func (v Verifier) VerifySeal(info spproof.SealVerifyInfo) (bool, error) {
	info.Randomness = Ticket
	return ffi.VerifySeal(info)
}

func (v Verifier) VerifyAggregateSeals(aggregate spproof.AggregateSealVerifyProofAndInfos) (bool, error) {
	for i, _ := range aggregate.Infos {
		aggregate.Infos[i].Randomness = Ticket
	}
	return ffi.VerifyAggregateSeals(aggregate)
}

func (v Verifier) VerifyWindowPoSt(info spproof.WindowPoStVerifyInfo) (bool, error) {
	info.Randomness[31] &= 0x3f
	return ffi.VerifyWindowPoSt(info)
}

func (v Verifier) VerifyAggregateWindowPostProofs(aggregate spproof.AggregateWindowPostInfos) (bool, error) {
	for i, random := range aggregate.Randomnesses {
		aggregate.Randomnesses[i][31] = random[31] & 0x3f
	}

	return ffi.VerifyAggregateWindowPoStProofs(aggregate)
}

func (v Verifier) VerifyPieceAndDataRoot(
	proofType abi.RegisteredSealProof,
	commd cid.Commit,
	pieces []abi.PieceInfo,
) (bool, error) {
	UnsealedCID, err := ffi.GenerateUnsealedCID(proofType, pieces)
	if err != nil {
		return false, err
	}

	return commd == UnsealedCID, nil
}
