package seal

import (
	// "sync"
	"os"
	"context"
	"fmt"
	"time"
	"github.com/minio/blake2b-simd"
)

func GenerateRandomData(filename string, dataSize uint64, b []byte) ([]byte, error) {
	if _, err := os.Stat(filename); !os.IsNotExist(err) {
		os.Remove(filename)
	}
	// r := rand.New(rand.NewSource(time.Now().UnixNano()))
	// Datasize := (r.Intn(1024*1024) + 1024*1024) * 32
	var i uint64
	buf := make([]byte, dataSize)
	for i = 0; i < dataSize; i += 32 {
		tmp := blake2b.Sum256(b)
		b = tmp[:]
		copy(buf[i:], b[:])
	}
	f, err := os.OpenFile(filename, os.O_CREATE|os.O_WRONLY, 0644)
	if err != nil {
		return nil, err
	}
	defer f.Close()
	_, err = f.Write(buf[:])
	if err != nil {
		return nil, err
	}
	return b, nil
}