package main

import (
	"os"

	logging "github.com/ipfs/go-log/v2"
	"github.com/urfave/cli/v2"

	"fil_integrate/actor"
	"fil_integrate/actor/connect"
)

var log = logging.Logger("bench")

func main() {
	logging.SetLogLevel("*", "INFO")

	log.Info("Starting test")

	app := &cli.App{
		Name:    "test",
		Usage:   "test  the actor(user, provider, keeper)",
		Version: "1.0.1",
		Commands: []*cli.Command{
			testConnect,
			testAllActor,
		},
	}

	if err := app.Run(os.Args); err != nil {
		log.Warnf("%+v", err)
		return
	}
}

var testConnect = &cli.Command{
	Name:  "test-connect",
	Usage: "Test Seal the sectors and generate window post",
	Action: func(c *cli.Context) error {
		err := connect.TestConnection()
		if err != nil {
			return err
		}
		return nil
	},
}

var testAllActor = &cli.Command{
	Name:  "test-all-actors",
	Usage: "Test Seal the sectors and generate window post",
	Action: func(c *cli.Context) error {
		err := actor.TestActor()
		if err != nil {
			return err
		}
		return nil
	},
}
