package proof

import (
	"fil_integrate/build/cid"
	"fil_integrate/build/state-types/abi"
)

type SectorInfo struct {
	SealType     abi.RegisteredSealProof // RegisteredProof used when sealing - needs to be mapped to PoSt registered proof when used to verify a PoSt
	SectorNumber abi.SectorNumber
	SealedCID    cid.Commit // CommR
}

type Proof []byte

type SealVerifyInfo struct {
	SealType              abi.RegisteredSealProof
	Miner                 abi.ActorID
	Number                abi.SectorNumber
	Randomness            abi.SealRandomness
	InteractiveRandomness abi.InteractiveSealRandomness
	SealProof             Proof

	// Safe because we get those from the miner actor
	SealedCID   cid.Commit `checked:"true"` // CommR
	UnsealedCID cid.Commit `checked:"true"` // CommD
}

type AggregateSealVerifyInfo struct {
	Number                abi.SectorNumber
	Randomness            abi.SealRandomness
	InteractiveRandomness abi.InteractiveSealRandomness

	// Safe because we get those from the miner actor
	SealedCID   cid.Commit `checked:"true"` // CommR
	UnsealedCID cid.Commit `checked:"true"` // CommD
}

type AggregateSealVerifyProofAndInfos struct {
	Miner          abi.ActorID
	SealType       abi.RegisteredSealProof
	AggregateType  abi.RegisteredAggregationProof
	AggregateProof Proof
	Infos          []AggregateSealVerifyInfo
}

type PoStProof struct {
	PoStProof  abi.RegisteredPoStProof
	ProofBytes Proof
}

type WinningPoStVerifyInfo struct {
	Randomness        abi.PoStRandomness
	Proofs            []PoStProof
	ChallengedSectors []SectorInfo
	Prover            abi.ActorID // used to derive 32-byte prover ID
}

type WindowPoStVerifyInfo struct {
	Randomness        abi.PoStRandomness
	Proof             PoStProof
	ChallengedSectors []SectorInfo
	Prover            abi.ActorID // used to derive 32-byte prover ID
}

type AggregateWindowPostInfos struct {
	PoStType          abi.RegisteredPoStProof
	AggregateType     abi.RegisteredAggregationProof
	AggregateProof    PoStProof
	ChallengedSectors []SectorInfo
	SectorCount       []uint
	Randomnesses      []abi.PoStRandomness
	Prover            abi.ActorID
}
