package connect

import (
	spieces "fil_integrate/build/pieces"
	spproof "fil_integrate/build/proof"
	"fil_integrate/build/state-types/abi"
	"fil_integrate/build/storage"
)

type Operator int

const (
	OP_REQUEST_PIECE Operator = iota
	OP_SEND_PIECE
	OP_ENCODE_DONE
	OP_SEAL_DONE
	OP_REQUEST_SEAL_RANDOM
	OP_REQUEST_POST_RANDOM
	OP_SEND_SEAL_RANDOM
	OP_SEND_POST_RANDOM
	OP_SEND_SEAL_PROOF
	OP_SEND_AGGREGATE_SEAL_PROOF
	OP_REQUEST_WINDOW_POST
	OP_SEND_WINDOW_POST_PROOF
	OP_SEND_AGGREGATE_WINDOW_POST_PROOF
	OP_CLOSED
)

type Data struct {
	op   Operator
	data interface{}
}

type PieceInfo struct {
	Data  []byte
	Proof spieces.MerkleProof
	Piece abi.PieceInfo
}

type SealProofInfo struct {
	Proof  spproof.Proof
	Sector abi.SectorID
	Commit storage.SectorCids
}

type AggregateSealProofInfo struct {
	Proof   spproof.Proof
	Sectors []abi.SectorID
	Commits []storage.SectorCids
}

type WindowPoStChallenge struct {
	Sectors    []abi.SectorID
	Randomness abi.PoStRandomness
}

type WindowPoStProofInfo struct {
	Proof      spproof.PoStProof
	Randomness abi.PoStRandomness
	Miner      abi.ActorID
}

type AggregateWindowPoStProofInfo struct {
	Proof        spproof.PoStProof
	Randomnesses []abi.PoStRandomness
	Miner        abi.ActorID
}
