package verifreg

import (
	"github.com/filecoin-project/go-address"
	"github.com/filecoin-project/go-state-types/abi"
	"github.com/ipfs/go-cid"

	"github.com/filecoin-project/lotus/chain/actors"
	"github.com/filecoin-project/lotus/chain/actors/adt"

	builtin3 "github.com/filecoin-project/specs-actors/v3/actors/builtin"
	verifreg3 "github.com/filecoin-project/specs-actors/v3/actors/builtin/verifreg"
	adt3 "github.com/filecoin-project/specs-actors/v3/actors/util/adt"
)

var _ State = (*state3)(nil)

func load3(store adt.Store, root cid.Cid) (State, error) {
	out := state3{store: store}
	err := store.Get(store.Context(), root, &out)
	if err != nil {
		return nil, err
	}
	return &out, nil
}

func make3(store adt.Store, rootKeyAddress address.Address) (State, error) {
	out := state3{store: store}

	s, err := verifreg3.ConstructState(store, rootKeyAddress)
	if err != nil {
		return nil, err
	}

	out.State = *s

	return &out, nil
}

type state3 struct {
	verifreg3.State
	store adt.Store
}

func (s *state3) RootKey() (address.Address, error) {
	return s.State.RootKey, nil
}

func (s *state3) VerifiedClientDataCap(addr address.Address) (bool, abi.StoragePower, error) {
	return getDataCap(s.store, actors.Version3, s.verifiedClients, addr)
}

func (s *state3) VerifierDataCap(addr address.Address) (bool, abi.StoragePower, error) {
	return getDataCap(s.store, actors.Version3, s.verifiers, addr)
}

func (s *state3) ForEachVerifier(cb func(addr address.Address, dcap abi.StoragePower) error) error {
	return forEachCap(s.store, actors.Version3, s.verifiers, cb)
}

func (s *state3) ForEachClient(cb func(addr address.Address, dcap abi.StoragePower) error) error {
	return forEachCap(s.store, actors.Version3, s.verifiedClients, cb)
}

func (s *state3) verifiedClients() (adt.Map, error) {
	return adt3.AsMap(s.store, s.VerifiedClients, builtin3.DefaultHamtBitwidth)
}

func (s *state3) verifiers() (adt.Map, error) {
	return adt3.AsMap(s.store, s.Verifiers, builtin3.DefaultHamtBitwidth)
}

func (s *state3) GetState() interface{} {
	return &s.State
}
