package reward

import (
	"github.com/filecoin-project/go-state-types/abi"
	"github.com/ipfs/go-cid"

	"github.com/filecoin-project/lotus/chain/actors/adt"
	"github.com/filecoin-project/lotus/chain/actors/builtin"

	miner0 "github.com/filecoin-project/specs-actors/actors/builtin/miner"
	reward0 "github.com/filecoin-project/specs-actors/actors/builtin/reward"
	smoothing0 "github.com/filecoin-project/specs-actors/actors/util/smoothing"
)

var _ State = (*state0)(nil)

func load0(store adt.Store, root cid.Cid) (State, error) {
	out := state0{store: store}
	err := store.Get(store.Context(), root, &out)
	if err != nil {
		return nil, err
	}
	return &out, nil
}

func make0(store adt.Store, currRealizedPower abi.StoragePower) (State, error) {
	out := state0{store: store}
	out.State = *reward0.ConstructState(currRealizedPower)
	return &out, nil
}

type state0 struct {
	reward0.State
	store adt.Store
}

func (s *state0) ThisEpochReward() (abi.TokenAmount, error) {
	return s.State.ThisEpochReward, nil
}

func (s *state0) ThisEpochRewardSmoothed() (builtin.FilterEstimate, error) {

	return builtin.FromV0FilterEstimate(*s.State.ThisEpochRewardSmoothed), nil

}

func (s *state0) ThisEpochBaselinePower() (abi.StoragePower, error) {
	return s.State.ThisEpochBaselinePower, nil
}

func (s *state0) TotalStoragePowerReward() (abi.TokenAmount, error) {
	return s.State.TotalMined, nil
}

func (s *state0) EffectiveBaselinePower() (abi.StoragePower, error) {
	return s.State.EffectiveBaselinePower, nil
}

func (s *state0) EffectiveNetworkTime() (abi.ChainEpoch, error) {
	return s.State.EffectiveNetworkTime, nil
}

func (s *state0) CumsumBaseline() (reward0.Spacetime, error) {
	return s.State.CumsumBaseline, nil
}

func (s *state0) CumsumRealized() (reward0.Spacetime, error) {
	return s.State.CumsumRealized, nil
}

func (s *state0) InitialPledgeForPower(sectorWeight abi.StoragePower, networkTotalPledge abi.TokenAmount, networkQAPower *builtin.FilterEstimate, circSupply abi.TokenAmount) (abi.TokenAmount, error) {
	return miner0.InitialPledgeForPower(
		sectorWeight,
		s.State.ThisEpochBaselinePower,
		networkTotalPledge,
		s.State.ThisEpochRewardSmoothed,
		&smoothing0.FilterEstimate{
			PositionEstimate: networkQAPower.PositionEstimate,
			VelocityEstimate: networkQAPower.VelocityEstimate,
		},
		circSupply), nil
}

func (s *state0) PreCommitDepositForPower(networkQAPower builtin.FilterEstimate, sectorWeight abi.StoragePower) (abi.TokenAmount, error) {
	return miner0.PreCommitDepositForPower(s.State.ThisEpochRewardSmoothed,
		&smoothing0.FilterEstimate{
			PositionEstimate: networkQAPower.PositionEstimate,
			VelocityEstimate: networkQAPower.VelocityEstimate,
		},
		sectorWeight), nil
}

func (s *state0) GetState() interface{} {
	return &s.State
}
