// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package market

import (
	"fmt"
	"io"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = sort.Sort

var lengthBufFundedAddressState = []byte{131}

func (t *FundedAddressState) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}
	if _, err := w.Write(lengthBufFundedAddressState); err != nil {
		return err
	}

	scratch := make([]byte, 9)

	// t.Addr (address.Address) (struct)
	if err := t.Addr.MarshalCBOR(w); err != nil {
		return err
	}

	// t.AmtReserved (big.Int) (struct)
	if err := t.AmtReserved.MarshalCBOR(w); err != nil {
		return err
	}

	// t.MsgCid (cid.Cid) (struct)

	if t.MsgCid == nil {
		if _, err := w.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCidBuf(scratch, w, *t.MsgCid); err != nil {
			return xerrors.Errorf("failed to write cid field t.MsgCid: %w", err)
		}
	}

	return nil
}

func (t *FundedAddressState) UnmarshalCBOR(r io.Reader) error {
	*t = FundedAddressState{}

	br := cbg.GetPeeker(r)
	scratch := make([]byte, 8)

	maj, extra, err := cbg.CborReadHeaderBuf(br, scratch)
	if err != nil {
		return err
	}
	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 3 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Addr (address.Address) (struct)

	{

		if err := t.Addr.UnmarshalCBOR(br); err != nil {
			return xerrors.Errorf("unmarshaling t.Addr: %w", err)
		}

	}
	// t.AmtReserved (big.Int) (struct)

	{

		if err := t.AmtReserved.UnmarshalCBOR(br); err != nil {
			return xerrors.Errorf("unmarshaling t.AmtReserved: %w", err)
		}

	}
	// t.MsgCid (cid.Cid) (struct)

	{

		b, err := br.ReadByte()
		if err != nil {
			return err
		}
		if b != cbg.CborNull[0] {
			if err := br.UnreadByte(); err != nil {
				return err
			}

			c, err := cbg.ReadCid(br)
			if err != nil {
				return xerrors.Errorf("failed to read cid field t.MsgCid: %w", err)
			}

			t.MsgCid = &c
		}

	}
	return nil
}
