package main

import(
	"os"

	"github.com/urfave/cli/v2"
	"github.com/docker/go-units"
	"github.com/filecoin-project/go-state-types/abi"
	logging "github.com/ipfs/go-log/v2"

	"fil_integrate/seal"

)

var log = logging.Logger("bench")

func main() {
	logging.SetLogLevel("*", "INFO")

	log.Info("Starting bench")

	app := &cli.App{
		Name:    "bench",
		Usage:   "Benchmark performance of seal and window-post",
		Version: "1.11.1",
		Commands: []*cli.Command{
			testSealCmd,
			testAggregationCmd,
		},
	}

	if err := app.Run(os.Args); err != nil {
		log.Warnf("%+v", err)
		return
	}
}

var testSealCmd = &cli.Command{
	Name:   "test-seal",
	Usage:  "Test interface",
	Action: func(c *cli.Context) error {
		// Test 8MiB sector
		err := seal.TestSealAndUnseal()
		if err != nil {
			return err
		}
		return nil
	},
}

var testAggregationCmd = &cli.Command{
	Name:   "test-aggregation",
	Usage:  "Test interface",
	Flags: []cli.Flag{
		&cli.StringFlag{
			Name:   "sector-size",
			Value:  "2KiB",
			Usage:  "size of the sectors in bytes",
		},
		&cli.IntFlag{
			Name:   "num-sectors",
			Value:  4,
			Usage:  "How many sectors used in single window post",
		},
		&cli.IntFlag{
			Name:   "num-agg",
			Value:  4,
			Usage:  "How many window-post proofs used to aggregate",
		},
	},
	Action: func(c *cli.Context) error {
		log.Info("testing")
		sectorSizeInt, err := units.RAMInBytes(c.String("sector-size"))
		if err != nil {
			return err
		}
		sectorSize := abi.SectorSize(sectorSizeInt)
		numSectors := c.Int("num-sectors")
		numAggregate := c.Int("num-agg")

		err = seal.TestAggregateWindowPoSt(sectorSize, numSectors, numAggregate)
		if err != nil {
			return err
		}
		return nil
	},
}