package storage

import (
	"io"

	"fil_integrate/build/state-types/abi"
	"fil_integrate/build/cid"
)
const SectorSize32MiB uint64 = 32*1024*1024

type Data = io.Reader

type PieceRef cid.Commit

type SectorRef struct {
	ID        abi.SectorID
	ProofType abi.RegisteredSealProof
}

type RangeSector struct {
	Sector   SectorRef
	Unsealed cid.Commit
	Offset   abi.UnpaddedByteIndex
	Size     abi.UnpaddedPieceSize
}

type PreCommit1Out []byte

type Commit1Out []byte

type SectorCids struct {
	Unsealed cid.Commit
	Sealed   cid.Commit
}

type Piece struct {
	Commitment cid.Commit
	Size       abi.UnpaddedPieceSize
}
