package provider

import (
	"context"

	"fil_integrate/build/cid"
	spproof "fil_integrate/build/proof"
	"fil_integrate/build/state-types/abi"
	"fil_integrate/build/storage"
)

type ProviderAPI interface {
	SavePiece(ctx context.Context, piece abi.PieceInfo, in storage.Data) error
	NextSectorID() storage.SectorRef
	MinerID() abi.ActorID

	AddPiece(ctx context.Context, sid storage.SectorRef) error
	Sealed(ctx context.Context, sid storage.SectorRef) (storage.SectorCids, error)

	ReadPiece(ctx context.Context, pieceID cid.Commit) ([]byte, error)

	GenerateCommitProof(ctx context.Context, sid storage.SectorRef, commit storage.SectorCids, seed abi.InteractiveSealRandomness) (spproof.Proof, error)
	AggregateSealProofs(ctx context.Context, sids []storage.SectorRef, commits []storage.SectorCids, seeds []abi.InteractiveSealRandomness, proofs []spproof.Proof) (spproof.Proof, error)
	GenerateWindowPoStProofs(ctx context.Context, sids []storage.SectorRef, commits []storage.SectorCids, randomness abi.PoStRandomness) (spproof.PoStProof, []abi.SectorID, error)
	AggregateWindowPoStProofs(ctx context.Context, sidsArr [][]storage.SectorRef, commitsArr [][]storage.SectorCids, randomnesses []abi.PoStRandomness, proofs []spproof.PoStProof) (spproof.PoStProof, error)
}
