package keeper

import (
	"context"

	"fil_integrate/build/cid"
	spproof "fil_integrate/build/proof"
	"fil_integrate/build/state-types/abi"
	"fil_integrate/build/storage"
)

type KeeperAPI interface {
	VerifyPieceAndDataRoot(commd cid.Commit, pieces []abi.PieceInfo) (bool, error)
	VerifySeal(ctx context.Context, sid abi.SectorID, randomness abi.InteractiveSealRandomness, commit storage.SectorCids, proof spproof.Proof) (bool, error)
	VerifyAggregateSeals(ctx context.Context, sids []abi.SectorID, randomnesses []abi.InteractiveSealRandomness, commits []storage.SectorCids, proof spproof.Proof) (bool, error)
	
	VerifyWindowPoSt(ctx context.Context, sids []abi.SectorID, randomness abi.PoStRandomness, proof spproof.PoStProof) (bool, error)
	VerifyAggregateWindowPostProofs(ctx context.Context, sidsArr [][]abi.SectorID, randomnesses []abi.PoStRandomness, proof spproof.PoStProof) (bool, error)
}
